<?php
	include_once('/home/USERNAME/includes/fields.phpi');
	$imaginaries = array(
		'rabbit'=>'The White Rabbit',
		'scarecrow'=>'The Scarecrow',
		'tinman'=>'The Tin Man',
		'neo'=>'Neo',
	);
	$fictions = new VoteCounter('character', $imaginaries);
	$fictions->setTitle('Your favorite imaginary imaginary character');
	$fictions->color = 'lightblue';
	$fictions->save();

	$presidents = file('/home/USERNAME/includes/presidents.txt', FILE_IGNORE_NEW_LINES);
	$election = new VoteCounter('president', $presidents);
	$election->save();

	$ballots = array($fictions, $election);
?>
<!doctype html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<title>Latest Polls</title>
		<style>
			body {
				margin: 10em;
				padding: 2em;
				border: solid .2em green;
			}
			h1 {
				text-align: center;
			}
			th {
				text-align: right;
			}
			table.graph {
				width: 90%;
			}
			table.graph td {
				width: 70%;
			}
			table.graph p {
				text-align: right;
				margin: 0;
				padding: .1em;
			}
		</style>
	</head>
	<body>
		<h1>Current Polls</h1>

		<?php FOREACH ($ballots as $vote):?>
			<hr />
			<h2><?php echo $vote->title(); ?></h2>
			<?php IF ($vote->answered()):?>
				<p>Thank you for voting for <?php echo $vote->name(); ?>!</p>
				<p>The current results are:</p>
				<table class="graph">
					<?php $results = $vote->counts(); ?>
					<?php FOREACH ($results->votes as $choice=>$count):?>
						<tr>
							<th><?php echo $vote->choiceName($choice); ?></th>
							<td>
								<p style="
									background-color: <?php echo $vote->color; ?>;
									width: <?php echo $count*$results->multiplier; ?>%;
								">
									<?php echo $count; ?>
								</p>
							</td>
						</tr>
					<?php ENDFOREACH;?>
				</table>
			<?php ELSE:?>
				<form method="post" action="poll-graph.php">
					<p>
						Please choose a <?php echo $vote->fieldName; ?>:
						<?php echo $vote->formSelect(); ?>
						<input type="submit" value="Submit your answer" />
					</p>
				</form>
			<?php ENDIF;?>
		<?php ENDFOREACH; ?>
	</body>
</html>
